/*
 *  sqMacLocaleOS9.c
 *  SqueakLocale
 *
 *  Created by John M McIntosh on 6/9/05.
 *
 */

#include "sqMacLocaleOS9.h"
#include "script.h"
#include <MacLocales.h>

/* Locale support functions */
Intl0Hndl   itl0;
Intl0Rec intMarksR;
sqInt sqLocInitialize(void) {
    itl0 = (Intl0Hndl)GetIntlResource(0);
	intMarksR = **itl0;
	return true;
}
/************** Country and language ******************/
void 	getCountryOrLanguage(char *str,LocalePartMask which);
void 	getCountryOrLanguage(char *str,LocalePartMask which){
	RegionCode			regionCode;
	LangCode			languageCode;
	OSStatus 			err;
	char				string[18];
	LocaleRef 			locale=NULL;
	
	languageCode = GetScriptManagerVariable(smScriptLang);
	regionCode = GetScriptManagerVariable(smRegionCode);
	err = LocaleRefFromLangOrRegionCode (languageCode, regionCode, &locale);
	err = LocaleRefGetPartString (locale, which, 18, string);
	memcpy(str,string,3);	
}

/* write the country code into the string ptr. ISO 3166 is the relevant source
 * here; see http://www.unicode.org/onlinedat/countries.html for details.
 * Using the 3 character Alpha-3 codes */
void	sqLocGetCountryInto(char * str) {
	getCountryOrLanguage(str,kLocaleRegionMask);
}

/* write the 3 char string describing the language in use into string ptr.
 * ISO 639 is the relevant source here;
 * see http://www.w3.org/WAI/ER/IG/ert/iso639.html
 * for details */
void	sqLocGetLanguageInto(char * str) {
	getCountryOrLanguage(str,kLocaleLanguageMask);
}

/***************** Currency ********************/

/* return 1 (true) if the currency symbol is to be placed in front of the
 *currency amount */
sqInt	sqLocCurrencyNotation(void) {
	return intMarksR.currFmt & currSymLead;
}

/* return the length in chars of the curency symbol string */
sqInt	sqLocCurrencySymbolSize(void) {
	char currencySymbol[4];
	
    strncpy(currencySymbol, &intMarksR.currSym1, 3);
    currencySymbol[3] = 0x00;

	return strlen(currencySymbol);
}
/* write the currency symbol into the string ptr */
void	sqLocGetCurrencySymbolInto(char * str) {
	char currencySymbol[4];

    strncpy(currencySymbol, &intMarksR.currSym1, 3);
    currencySymbol[3] = 0x00;
	strcpy(str, currencySymbol);
}


/***************** Numbers and measurements **************/

/* return true if the metric measurements system is to be used, false otherwise
 * (USA is about it) */
sqInt	sqLocMeasurementMetric(void) {
	return intMarksR.metricSys > 0;
}

/* write the 1 char used for digit grouping into string ptr.
 * Usually this is . or ,  as in 1,000,000 */
void	sqLocGetDigitGroupingSymbolInto(char * str) {
	strncpy(str, &intMarksR.thousSep, 1);
}
/* write the 1 char used for decimal separation into string ptr.
 * Usually this is . or , */
void	sqLocGetDecimalSymbolInto(char * str) {
	strncpy(str, &intMarksR.decimalPt, 1);
}


/****************** time and date *********************/

sqInt	sqLocGetVMOffsetToUTC(void) {
	/* return 0 for now */
	return 0;
}

sqInt	sqLocGetTimezoneOffset(void) {
	unsigned long now,utc;
	GetDateTime(&now);
	ConvertLocalTimeToUTC(now,&utc);
	return ((sqInt) (now-utc)/60);
}

/* return true if DST is in use, false otherwise */
sqInt	sqLocDaylightSavings(void) {
struct tm * timeBlock;
time_t theTime;
	theTime = time((time_t)NULL);
	timeBlock = localtime(&theTime);
	return timeBlock->tm_isdst;
}

void dateFormatIs(Str255 buffer,DateForm type );
void timeFormatIs(Str255 buffer,DateForm type );

void dateFormatIs(Str255 buffer,DateForm type ) {
    DateString (0+24*60*60+1,type,buffer,0);
}

void timeFormatIs(Str255 buffer,DateForm type ) {
	TimeString (0+24*60*60+1,true,buffer,0);
}

/* return the size in chars of the long date format string */
sqInt	sqLocLongDateFormatSize(void) {
	Str255 buffer;
	dateFormatIs(buffer,longDate);

	return buffer[0];
}
/*Write the string describing the long date formatting into string ptr.
 * Format is made up of
 * 		d day, m month, y year,
 * 		double symbol is null padded, single not padded (m=6, mm=06)
 * 		dddd weekday
 * 		mmmm month name */
void	sqLocGetLongDateFormatInto(char * str) {
	Str255 buffer;
	dateFormatIs(buffer,longDate);
	p2cstr(buffer);
	memcpy(str, (char *) buffer,strlen((char*)buffer));
}

/* return the size in chars of the short date format string */
sqInt	sqLocShortDateFormatSize(void) {
	Str255 buffer;
	dateFormatIs(buffer,shortDate);

	return buffer[0];
}
/*Write the string describing the short date formatting into string ptr.
 * Format is made up of
 * 		d day, m month, y year,
 * 		double symbol is null padded, single not padded (m=6, mm=06)
 * 		dddd weekday
 * 		mmmm month name */
void	sqLocGetShortDateFormatInto(char * str) {
	Str255 buffer;
	dateFormatIs(buffer,shortDate);
	p2cstr(buffer);
	memcpy(str,(char *) buffer,strlen((char*)buffer));
}

/* return the size in chars of the time format string */
sqInt	sqLocTimeFormatSize(void) {
	Str255 buffer;
	timeFormatIs(buffer,shortDate);

	return buffer[0];
}
/* write the string describing the time formatting into string ptr.
 * Format is made up of
 * 		h hour (h 12, H 24), m minute, s seconds, x (am/pm String)
 * 		double symbol is null padded, single not padded (h=6, hh=06)  */
void	sqLocGetTimeFormatInto(char * str) {
	Str255 buffer;
	timeFormatIs(buffer,shortDate);
	p2cstr(buffer);
	memcpy(str, (char*) buffer,strlen((char*)buffer));
}
